#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
in vec2 fsFragScale;


in vec2 fsTexture;
in float fsMix;
out vec4 outColor;

void main()
{
    outColor = texture(inputTex, fsTexture);
    float alpha = baseAlpha * fsMix;
#ifdef USE_MASK
    alpha *= texture(maskTex, gl_FragCoord.xy * fsFragScale).a;
#endif
    multiplyOpacity(outColor, alpha);
}
