#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform int transitionState;
uniform int direction=0;
uniform sampler2DRect maskTex;
in vec2 fsMaskTexture;
in vec2 fsMaskTextureSize;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureNormalized;
in vec2 fsTextureSize;
in float fsMix;
in vec2 fsNormPos;
out vec4 outColor;

const vec2 directionTable[9] = vec2[] (
                                       vec2( 1, -1),
                                       vec2( 0, -1),
                                       vec2(-1, -1),
                                       vec2( 1,  0),
                                       vec2( 0,  0),
                                       vec2(-1,  0),
                                       vec2( 1,  1),
                                       vec2( 0,  1),
                                       vec2(-1,  1)
                                       );

const vec2 center = vec2(0.5, 0.5);

void main()
{
    vec4 colorA = texture(inputTex, fsTexture);
    vec4 colorB = texture(inputTex1, fsTexture2);

    vec2 dir = normalize(directionTable[direction] * fsMaskTextureSize);
    float diagonalScale = abs(dir.x) + abs(dir.y);
    if (diagonalScale > 0)
        dir /= diagonalScale;
    float prog = dot(dir, fsNormPos) - dot(dir, center) + (1 - transitionProgress) * 1.2 - 0.1;
    float blend = smoothstep(0.4, 0.6, prog);
    blend = mix(1 - blend, blend, fsMix);

    mixColor(outColor, colorA, colorB, blend);

    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
