#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;
in float fsTheta;
in float fsProgress;
in float fsMix;

out vec4 outColor;

vec2 offset(float scale,float progress, float x, float theta)
{
    float phase = progress*progress + progress + theta;
    float shifty = 0.023*scale*cos(10.0*(progress+x));
    return vec2(0, shifty);
}

void main()
{
    vec2 p1 = fsTextureNormalized;
    vec2 p2 = fsTextureNormalized2;

    vec4 colorA=texture(inputTex,(p1+offset(fsProgress,fsMix,p1.x,0.0))*fsTextureSize);
    vec4 colorB=texture(inputTex1,(p2+offset(fsProgress,fsMix,p2.x,3.145))*fsTextureSize2);

    mixColor(outColor, colorB, colorA, transitionProgressLinear);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}
