#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect maskTex;
out vec2 fsMaskTexture;

uniform sampler2DRect inputTex;
uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgressLinear=1.0;
uniform sampler2DRect inputTex1;
uniform int direction;
uniform float verticalDirectionFlip = 1.0;

out vec2 fsTexture;
out vec2 fsTexture2;
out float fsMix;
out vec2 fsDirection;
out vec2 fsNormPos;

const vec2 directionTable[9] = vec2[] (
                                       vec2( 1, -1),
                                       vec2( 0, -1),
                                       vec2(-1, -1),
                                       vec2( 1,  0),
                                       vec2( 0,  0),
                                       vec2(-1,  0),
                                       vec2( 1,  1),
                                       vec2( 0,  1),
                                       vec2(-1,  1)
                                       );

void main()
{
	gl_Position=vec4(vsPosition,1.0)*worldViewProj;

	ivec2 texSize=textureSize(inputTex);
	fsTexture = vsTexture*vec2(texSize);

    fsNormPos = vsPosition.xy * 0.5 + vec2(0.5, 0.5);
    vec2 maskTextureSize = vec2(textureSize(maskTex));
    fsDirection = normalize(directionTable[direction] * maskTextureSize);
    fsDirection.y *= verticalDirectionFlip;

	fsMix=1.0;
	if(transitionState==0)
		fsMix=0.0;

	texSize=textureSize(inputTex1);
	fsTexture2 = vsTexture2*vec2(texSize);
    fsMaskTexture = vsTextureMask * maskTextureSize;
}
