#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;

out vec4 outColor;

void main(void)
{
    vec2 p = fsTextureNormalized;
    vec2 p2 = fsTextureNormalized2;

    float T = transitionProgress;
    
    float S0 = 1.0;
    float S1 = 250.0;
    float S2 = 1.0;

    // 2 segments, 1/2 each
    float Half = 0.5;

    float PixelSize = ( T < Half ) ? mix( S0, S1, T / Half ) : mix( S1, S2, (T-Half) / Half );

    vec2 D = PixelSize / fsTextureSize.xy;
    vec2 D2 = PixelSize / fsTextureSize2.xy;

    // remap UV from 0...1 to -0.5...+0.5 to make the mosaic pattern converge torwards the image center
    vec2 UV = ( p + vec2( -0.5 ) ) / D;
    vec2 UV2 = ( p2 + vec2( -0.5 ) ) / D2;

    // don't forget to remap coords back to 0...1 after ceil()
    vec2 Coord = clamp( D * ( ceil( UV + vec2( -0.5 ) ) ) + vec2( 0.5 ), vec2( 0.0 ), vec2( 1.0 ) );
    vec2 Coord2 = clamp( D2 * ( ceil( UV2 + vec2( -0.5 ) ) ) + vec2( 0.5 ), vec2( 0.0 ), vec2( 1.0 ) );

    vec4 colorA=texture(inputTex,Coord*fsTextureSize);
    vec4 colorB=texture(inputTex1,Coord2*fsTextureSize2);
    mixColor(outColor, colorB, colorA, transitionProgressLinear);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}
