#version 330

#include "transitionHelperGL.h"
#include "alpha.h"
#include "fadeHelper.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float transitionProgress = 1.0;
uniform float baseAlpha = 1.0;

in vec2 fsTexture;
in vec2 fsMaskTexture;
in float fsMix;

out vec4 outColor;

void main()
{
    vec4 texColor = getColor(inputTex, fsTexture);
    fadeDark(outColor, texColor, transitionProgress, fsMix);
    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
