#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform int transitionState;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform mat4 worldViewProj;

out vec2 fsTexture;
out vec2 fsTexture2;
out vec2 fsMaskTexture;
out float fsMix;

void main()
{
    gl_Position=vec4(vsPosition,1.0)*worldViewProj;

    if(transitionState!=2)
    {
        if(transitionProgressLinear<=.5)
        {
            fsMix=0.;
        }
        else
        {
            fsMix=(transitionProgressLinear-.5f)*2.;
        }
    }
    else
    {
        if(transitionProgressLinear<=.5)
        {
            fsMix=(.5-transitionProgressLinear)*2.;
        }
        else
        {
            fsMix=0.;
        }
    }
    fsTexture = vsTexture*vec2(textureSize(inputTex));
    fsTexture2= vsTexture2*vec2(textureSize(inputTex1));
    fsMaskTexture=vsTextureMask*vec2(textureSize(maskTex));
}
