
#include "metalShaderTypes.h"
#include "alpha.h"

vertex vertexOut vertexFunc(uint vertexID [[ vertex_id ]],const device txShaderVers* in[[ buffer(0) ]],constant txShaderUniforms& uniforms[[ buffer(3) ]])
{
    vertexOut out;

    out.position=in[vertexID].pos*uniforms.worldViewProj;

    out.tex1=in[vertexID].tex1;
    out.tex2=in[vertexID].tex2;
    out.texMask=in[vertexID].texMask;
    return out;
}

fragment float4 fragmentFunc(vertexOut input [[stage_in]]
                             ,texture2d<half> inputTex0 [[ texture(0) ]]
                             ,texture2d<half> inputTex1 [[ texture(1) ]]
                             ,texture2d<half> inputTexMask [[ texture(2) ]]
                             ,constant txShaderUniforms& u[[ buffer(2) ]]
                             ,constant subFXVars& subVars[[buffer(3)]])
{
    vec4 red,green,blue;
    vec2 texA,texB;

    texA=input.tex1;
    texA.x-=(1.0-u.transitionProgress);
    
    texB=input.tex1;
    texB.x-=u.transitionProgress;

    texA=mix(texB,texA,u.mix);
    red=getColor(inputTex0,texA)*u.baseAlpha;
    red*=vec4(1.,0.,0.,.33333);

    texA=input.tex1;
    texA.x+=(1.0-u.transitionProgress);

    texB=input.tex1;
    texB.x+=u.transitionProgress;

    texA=mix(texB,texA,u.mix);
    green=getColor(inputTex0,texA)*u.baseAlpha;
    green*=vec4(0.,1.,0.,.33333);

    texA=input.tex1;
    texA.y-=(1.0-u.transitionProgress);

    texB=input.tex1;
    texB.y-=u.transitionProgress;

    texA=mix(texB,texA,u.mix);
    blue=getColor(inputTex0,texA)*u.baseAlpha;
    blue*=vec4(0.,0.,1.,.33333);
    float4 outColor = red+green+blue;

#ifdef USE_MASK
    multiplyOpacity(outColor, float(inputTexMask.sample(linearSampler, input.texMask).a));
#endif

    return outColor;
}
