#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;

in vec2 fsTexture;
in vec2 fsTexSize;
in vec2 fsTextureNormalized;
in vec2 fsMaskTexture;
in float fsAlphaValue;
in float fsABSelect;

out vec4 outColor;

void main()
{
    vec4 red,green,blue;
    vec2 texA,texB;

    texA=fsTextureNormalized;
    texA.x-=(1.0-fsAlphaValue);
    texA*=fsTexSize;

    texB=fsTextureNormalized;
    texB.x-=fsAlphaValue;
    texB*=fsTexSize;
    
    texA=mix(texA,texB,fsABSelect);
    red=getColor(inputTex,texA);
    red*=vec4(1.,0.,0.,.33333);

    texA=fsTextureNormalized;
    texA.x+=(1.0-fsAlphaValue);
    texA*=fsTexSize;

    texB=fsTextureNormalized;
    texB.x+=fsAlphaValue;
    texB*=fsTexSize;

    texA=mix(texA,texB,fsABSelect);
    green=getColor(inputTex,texA);
    green*=vec4(0.,1.,0.,.33333);

    texA=fsTextureNormalized;
    texA.y-=(1.0-fsAlphaValue);
    texA*=fsTexSize;

    texB=fsTextureNormalized;
    texB.y-=fsAlphaValue;
    texB*=fsTexSize;

    texA=mix(texA,texB,fsABSelect);
    blue=getColor(inputTex,texA);
    blue*=vec4(0.,0.,1.,.33333);

    outColor = red+green+blue;
    outColor *= baseAlpha;
    // outColor.a=texture(inputTex,fsTexture).a;

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}


