#version 330


uniform sampler2DRect inputTex;

layout( std140 ) uniform vars
{
    float alpha;
    float curLevel;
    float peakLevel;
};

in vec2 fsTexture;
in vec2 fsTextureNormalized;
out vec4 outColor;

void main()
{
    outColor = texture(inputTex, fsTexture);
    if((1.0-fsTextureNormalized.y)>curLevel)
    {
        float diff=abs((1.0-fsTextureNormalized.y)-peakLevel);
        if(diff>.005)
        {
            outColor.a=alpha;
        }
    }
}

