//
// invert like a B&W negative
// updated to 330 and rvfx system by Jeff Brown
//


#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float uTransitionProgress=1.0;
uniform float uBlendValue=1.0;

in vec2 fsTexture;
in vec2 fsMaskTexture;
out vec4 outColor;

void main(void)
{
    vec4 texel = texture(inputTex, fsTexture);
#ifdef PRE_MULT
    divideAlpha(texel);
#endif

    // Convert to grayscale
    float gray = dot(texel.rgb, vec3(0.299, 0.587, 0.114));

    // invert
    gray = 1.0 - gray;

    // replicate grayscale to RGB components
    outColor = vec4(gray, gray, gray, texel.a);
    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    outColor.rgb=mix(texel.rgb,outColor.rgb,blendValue);
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
}

