constant vec4 std601X = vec4(  0.299 ,  0.587,  0.114, 0.0  );
constant vec4 std601Y = vec4( -0.169 , -0.331,  0.500, 0.0  );
constant vec4 std601Z = vec4(  0.500 , -0.419, -0.081, 0.0  );

constant vec4 std601R = vec4( 1.596027*0.85882394366802,1.164383*0.85882394366802, 0.000000,0.0  );
constant vec4 std601G = vec4(-0.812968*0.85882394366802,1.164383*0.85882394366802,-0.391762*0.85882394366802,0.0  );
constant vec4 std601B = vec4( 0.000000,1.164383*0.85882394366802, 2.017232*0.85882394366802,0.0  );

typedef struct
{
    float saturation;
} subFXVars;


float4 backgroundEffect(texture2d<half> objectTexture,
                        float2 objectTextureCoordinates,
                        texture2d<half> blurredBackgroundTexture,
                        texture2d<half> backgroundTexture,
                        float2 screenPosition,
                        constant txShaderUniforms& u,
                        constant subFXVars& vars)
{
    float4 objectColor=float4(objectTexture.sample(linearSampler,objectTextureCoordinates));
    float4 blurredBackgroundColor=float4(blurredBackgroundTexture.sample(linearSampler,screenPosition*u.uvScale+u.uvOffset));
    
    float4 yuvIn = vec4(dot(std601X, blurredBackgroundColor),
                 dot(std601Y, blurredBackgroundColor),
                 dot(std601Z, blurredBackgroundColor),
                 1.0 );

    float4 yuvOut;
    
    yuvOut.g = yuvIn.r;
    yuvOut.r = yuvIn.b * (vars.saturation+1.0);
    yuvOut.b = yuvIn.g * (vars.saturation+1.0);
    yuvOut.a = yuvIn.a;
    
    float4 outColor=vec4(dot(std601R, yuvOut),
                  dot(std601G, yuvOut),
                  dot(std601B, yuvOut),
                  1);

    outColor*=objectColor.a;

    return outColor;
}
