
#include "metalShaderTypes.h"
#include "alpha.h"

typedef struct
{
    int direction;
} fxVars;

vertex vertexOut vertexFunc(uint vertexID [[ vertex_id ]],const device txShaderVers* in[[ buffer(0) ]],constant txShaderUniforms& uniforms[[ buffer(3) ]],constant fxVars& vars[[ buffer(2)]])
{
    vertexOut out;

    out.position=in[vertexID].pos*uniforms.worldViewProj;

    out.tex1=in[vertexID].tex1;
    out.tex2=in[vertexID].tex2;
    out.texMask=in[vertexID].texMask;
    out.normPos=in[vertexID].pos.xy*vec2(.5,.5f)+vec2(.5,.5);
    return out;
}

fragment float4 fragmentFunc(vertexOut input [[stage_in]]
                             ,texture2d<half> inputTex0 [[ texture(0) ]]
                             ,texture2d<half> inputTex1 [[ texture(1) ]]
                             ,texture2d<half> inputTexMask [[ texture(2) ]]
                             ,constant txShaderUniforms& u[[ buffer(2) ]]
                             ,constant subFXVars& subVars[[buffer(3)]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    float x1 = u.transitionProgressLinear;
    vec2 p1 = input.tex1;
    vec2 p2 = input.tex2;

    float x2=smoothstep(.20,.80,(x1*2.0+p1.x-1.0));
    x1=smoothstep(.20,.80,(x1*2.0+p1.x-1.0));

    vec2 tc1=(p1-.5)*(1.-x1)+.5;
    vec2 tc2=(p2-.5)*(1.-x2)+.5;

    tc1=(p1-.5)*x1+.5;
    // tc2=(p2-.5)*x2+.5;

    vec4 colorA=getColor(inputTex0,tc1);
    vec4 colorB=getColor(inputTex1,tc2);
    float4 outColor;
    mixColor(outColor, colorB, colorA, u.transitionProgressLinear);

#ifdef USE_MASK
    multiplyOpacity(outColor, float(inputTexMask.sample(linearSampler, input.texMask).a));
#endif

    return outColor;
}
