#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
uniform sampler2DRect maskTex;
in vec2 fsMaskTexture;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsDirection;
in vec2 fsFragScale;
in float fsMix;

out vec4 outColor;

uniform ivec2 squares=ivec2(10,10);
uniform float smoothness=1.0;

const vec2 center = vec2(0.5, 0.5);

void main()
{
    vec2 p = gl_FragCoord.xy * fsFragScale;
    vec2 dir = fsDirection;
    float diagonalScale = abs(dir.x) + abs(dir.y);
    if (diagonalScale > 0)
        dir /= diagonalScale;
    float offset = smoothness;
    float prog = dot(dir, p) - dot(dir, center) + 0.5 - transitionProgressLinear * (1.0 + offset);
    float pr = smoothstep(-offset, 0.0, prog) * 0.5;
    vec2 squarep = fract(p * vec2(squares));
    vec2 squaremin = vec2(pr);
    vec2 squaremax = vec2(1.0 - pr);
    float which = all(lessThanEqual(squaremin, squarep)) && all(lessThanEqual(squarep, squaremax)) ? 1.0 : 0.0;
    vec4 texelA = texture(inputTex, fsTexture);
    vec4 texelB = texture(inputTex1, fsTexture2);
    outColor = mix(texelB, texelA, which);
    float alpha = baseAlpha;

#ifdef USE_MASK
    alpha *= texture(maskTex,fsMaskTexture).a;
#endif

    multiplyOpacity(outColor, alpha);
}
