#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
uniform sampler2DRect maskTex;
in vec2 fsMaskTexture;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;in float fsMix;

out vec4 outColor;

uniform float size=.4;
#define QUALITY 8


const float GOLDEN_ANGLE = 2.399963229728653; // PI * (3.0 - sqrt(5.0))

vec4 blur(sampler2DRect tpipe,vec2 c,vec2 tsize, float radius)
{
    vec4 sum = vec4(0.0);
    float q = float(QUALITY);
    // Using a "spiral" to propagate points.
    for (int i=0; i<QUALITY; ++i) {
        float fi = float(i);
        float a = fi * GOLDEN_ANGLE;
        float r = sqrt(fi / q) * radius;
        vec2 p = c + r * vec2(cos(a), sin(a));
        sum += texture(tpipe, p*tsize);
    }
    return sum / q;
}

void main()
{
    vec4 color1=blur(inputTex,fsTextureNormalized,fsTextureSize,fsMix*size);
    vec4 color2=blur(inputTex1,fsTextureNormalized2,fsTextureSize2,fsMix*size);
    mixColor(outColor, color2, color1, transitionProgressLinear);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}
