#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float radius;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

out vec2 fsTexture;
out vec2 fsMaskTexture;
out vec3 fsPosition;
out float fsInnerRadius;
out float fsOuterRadius;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);
    
    fsOuterRadius = radius * 0.01;
    fsInnerRadius = fsOuterRadius * 0.5;
    fsTexture = vsTexture;
    fsMaskTexture = vsTextureMask;
    fsPosition = vsPosition * 0.5;
}
