#include "metalShaderTypes.h"
#include "alpha.h"


constant float4 toXYZ_R = float4(0.4124, 0.3576, 0.1805, 0.0);
constant float4 toXYZ_G = float4(0.2126, 0.7152, 0.0722, 0.0);
constant float4 toXYZ_B = float4(0.0193, 0.1192, 0.9505, 0.0);

typedef struct
{
    float4 darkColor;
    float4 brightColor;
} fxVars;

vertex fxVertexOut vertexFunc(uint vertexID [[ vertex_id ]]
                              ,const device fxShaderVerts* in[[ buffer(0) ]]
                              ,texture2d<half> inputTex0 [[ texture(0) ]]
                              ,texture2d<half> inputTexMask [[ texture(1) ]]
                              ,constant fxGeneralUniforms& u[[ buffer(1) ]]
                              ,constant fxVars& vars[[ buffer(2)]])
{
    fxVertexOut out;

    out.normPos=in[vertexID].pos.xy*vec2(.5,-.5f);//+vec2(.5,.5);
    out.position=in[vertexID].pos;
    out.texSize=float2(inputTex0.get_width(),inputTex0.get_height());
    out.tex1=in[vertexID].tex1;
    out.texMask=in[vertexID].texMask;

    return out;
}

fragment float4 fragmentFunc(fxVertexOut input [[stage_in]]
                             ,texture2d<half> inputTex [[ texture(0) ]]
                             ,texture2d<half> inputTexMask [[ texture(1) ]]
                             ,constant fxGeneralUniforms& u[[ buffer(0) ]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    vec4 texel = getColor(inputTex, fsTexture);
#ifdef PRE_MULT
    divideAlpha(texel);
#endif

#ifdef LINEAR_16
    float4 darkColor = float4(dot(toXYZ_R, vars.darkColor), dot(toXYZ_G, vars.darkColor), dot(toXYZ_B, vars.darkColor), 1.0);
    float4 brightColor = float4(dot(toXYZ_R, vars.brightColor), dot(toXYZ_G, vars.brightColor), dot(toXYZ_B, vars.brightColor), 1.0);

    float gray = dot(texel.rgb  / u.nitsScale, vec3(0.355, 0.658, 0.004));

    // linear interp between darkColor and brightColor using gray scale
    float4 outColor;
    outColor.rgb=mix(darkColor.rgb*u.nitsScale,brightColor.rgb*u.nitsScale,gray);

#else
    // Convert to grayscale using NTSC conversion weights
    float gray = dot(texel.rgb, vec3(0.299, 0.587, 0.114));

    // linear interp between darkColor and brightColor using gray scale
    float4 outColor;
    outColor.rgb=mix(vars.darkColor.rgb*u.nitsScale,vars.brightColor.rgb*u.nitsScale,gray);
#endif

    outColor.a=texel.a;

    float blendValue=u.blendValue;
#ifdef USE_MASK
    blendValue *= getColor(inputTexMask, input.texMask).a;
#endif
    outColor.rgb=mix(texel.rgb,outColor.rgb,blendValue);
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
    return outColor;
}
