#include "metalShaderTypes.h"
#include "alpha.h"
#include "commonMLDX.h"
#include "outputColorHelper.h"

constant float4 std709X = float4(  0.183,   0.614,  0.062, 0.0  );
constant float4 std709Y = float4( -0.101,  -0.338,  0.439, 0.0  );
constant float4 std709Z = float4(  0.439,  -0.399, -0.040, 0.0  );

constexpr sampler nearestSampler(
    mip_filter::nearest,
    mag_filter::nearest,
    min_filter::nearest,
    address::clamp_to_border,
    border_color::transparent_black);


vertex vertexOut vertexFunc(uint vertexID [[ vertex_id ]],
                                   const device pixCopyVertexFormat* in [[ buffer(0) ]])
{
    vertexOut out;

    out.position = in[vertexID].pos;

    out.tex1 = in[vertexID].tc;
    out.tex2 = in[vertexID].tc;
    out.tex2.x+=1.0;

    return out;
}

fragment float4 fragmentFunc(vertexOut input [[stage_in]],
                             texture2d<half> inputTex0 [[ texture(0) ]])
{
    float2 texSize=float2(inputTex0.get_width(),inputTex0.get_height());
    float4 texColor0 = toOutput(float4(inputTex0.sample(nearestSampler,input.tex1/texSize)));

    float4 yuv0 = float4(dot(std709X, texColor0)+0.0625,
                         dot(std709Y, texColor0)+0.5,
                         dot(std709Z, texColor0)+0.5,
                         texColor0.a);

    float4 outColor=float4(yuv0.a,yuv0.r,yuv0.g,yuv0.b);
    return outColor;
}

