//

// Fragment shader for pixelize
//
// Author: Blah, i can neither confirm nor deny i wrote this
//
//

#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float uBlendValue;

in vec2 fsTexture;
in vec2 fsMaskTexture;
in vec2 fsTextureStep;
out vec4 outColor;

void main()
{
    vec4 texel = texture(inputTex, fsTexture);
    vec2 tmp=(fsTexture+fsTextureStep*.5)/fsTextureStep;
    ivec2 grad=ivec2(tmp);
    vec2 pixTexture=vec2(grad);
    pixTexture*=fsTextureStep;
    // pixTexture=mix(fsTexture,pixTexture,uBlendValue);

    outColor = texture(inputTex, pixTexture);
    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    mixColor(outColor, texel, outColor, blendValue);
}
