//
// Color Blobs
// more ShaderToy stuff
//

#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float blendValue;
uniform float uBlendValue=1.0;

in vec2 fsTexture;
in vec2 fsMaskTexture;
in vec2 fsNormalizedUV;
in vec2 fsTextureSize;
in float fsTime;
out vec4 outColor;


float makePoint(float x,float y,float fx,float fy,float sx,float sy,float t)
{
    float xx=x+sin(t*fx)*sx;
    float yy=y+cos(t*fy)*sy;
    return 1.0/sqrt(xx*xx+yy*yy);
}

void main()
{
    
//    vec2 p=(fragCoord.xy/iResolution.x)*2.0-vec2(1.0,iResolution.y/iResolution.x);
    vec2 p=fsNormalizedUV*2.0-vec2(1.,1.);
    
    float time=fsTime;
    
    p=p*.70;
    
    float x=p.x;
    float y=p.y;
    
    float a=
    makePoint(x,y,3.3,2.9,0.3,0.3,time);
    a=a+makePoint(x,y,1.9,2.0,0.4,0.4,time);
    a=a+makePoint(x,y,0.8,0.7,0.4,0.5,time);
    a=a+makePoint(x,y,2.3,0.1,0.6,0.3,time);
    a=a+makePoint(x,y,0.8,1.7,0.5,0.4,time);
    a=a+makePoint(x,y,0.3,1.0,0.4,0.4,time);
    a=a+makePoint(x,y,1.4,1.7,0.4,0.5,time);
    a=a+makePoint(x,y,1.3,2.1,0.6,0.3,time);
    a=a+makePoint(x,y,1.8,1.7,0.5,0.4,time);
    
    float b=
    makePoint(x,y,1.2,1.9,0.3,0.3,time);
    b=b+makePoint(x,y,0.7,2.7,0.4,0.4,time);
    b=b+makePoint(x,y,1.4,0.6,0.4,0.5,time);
    b=b+makePoint(x,y,2.6,0.4,0.6,0.3,time);
    b=b+makePoint(x,y,0.7,1.4,0.5,0.4,time);
    b=b+makePoint(x,y,0.7,1.7,0.4,0.4,time);
    b=b+makePoint(x,y,0.8,0.5,0.4,0.5,time);
    b=b+makePoint(x,y,1.4,0.9,0.6,0.3,time);
    b=b+makePoint(x,y,0.7,1.3,0.5,0.4,time);
    
    float c=
    makePoint(x,y,3.7,0.3,0.3,0.3,time);
    c=c+makePoint(x,y,1.9,1.3,0.4,0.4,time);
    c=c+makePoint(x,y,0.8,0.9,0.4,0.5,time);
    c=c+makePoint(x,y,1.2,1.7,0.6,0.3,time);
    c=c+makePoint(x,y,0.3,0.6,0.5,0.4,time);
    c=c+makePoint(x,y,0.3,0.3,0.4,0.4,time);
    c=c+makePoint(x,y,1.4,0.8,0.4,0.5,time);
    c=c+makePoint(x,y,0.2,0.6,0.6,0.3,time);
    c=c+makePoint(x,y,1.3,0.5,0.5,0.4,time);
    
    vec3 d=(vec3(a,b,c)-16.0)/32.0;
    d=clamp(vec3(0.),vec3(1.0),d);
    
    outColor = texture(inputTex, fsTexture);
    
    float combinedBlendValue=uBlendValue*blendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif

    d*=combinedBlendValue;
    outColor.rgb=(vec3(1.0)-((vec3(1.0)-outColor.rgb)*(vec3(1.0)-d)));
    
    
//    outColor.rgb=mix(outColor.rgb,blobColor.rgb,blendValue);
}

