#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform int transitionState;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform mat4 worldViewProj;

out vec2 fsTexture;
out vec2 fsTextureSize;
out vec2 fsTextureNormalized;
out float fsABSelect;

out vec2 fsMaskTexture;

void main()
{
    gl_Position=vec4(vsPosition,1.0)*worldViewProj;
    fsTextureSize=vec2(textureSize(inputTex));
    fsTexture = vsTexture*fsTextureSize;
    fsTextureNormalized=vsTexture;
    
    fsMaskTexture=vsTextureMask*vec2(textureSize(maskTex));
    
    fsABSelect=1.0;
    if(transitionState==2)
        fsABSelect=0.0;
}
