#version 330

uniform sampler2DRect inputTex;
uniform float uBlackLevel=0.0;
uniform float uIntensity=1.0;
uniform float uType=1.0;
uniform float uInvGamma=1.0;
uniform float uBlendValue=1.0;


in vec2 fsTexture;
in float fsProgress;
out vec4 outColor;

void main()
{
    outColor = texture(inputTex, fsTexture);
    float scale=min(1.0,uBlendValue*(1.0-pow(1.0-fsProgress,uType)*uIntensity));
    scale=pow(scale,uInvGamma);
    outColor.rgb*=vec3(scale,scale,scale);
}


