#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect maskTex;
out vec2 fsMaskTexture;


uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;

uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionAlpha=1.0;

out vec2 fsTexture;
out vec2 fsTexture2;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;

    fsTexture=vsTexture*vec2(textureSize(inputTex));
    fsTexture2=vsTexture2*vec2(textureSize(inputTex1));
    fsMaskTexture=vsTextureMask*vec2(textureSize(maskTex));
}
