#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
in vec2 fsMaskTexture;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;
in float fsMix;
in float fsABSelect;

out vec4 outColor;

uniform float size=.4;
#define QUALITY 8


const float GOLDEN_ANGLE = 2.399963229728653; // PI * (3.0 - sqrt(5.0))

vec4 blur(sampler2DRect tpipe,vec2 c,vec2 tsize, float radius)
{
    vec4 sum = vec4(0.0);
    float q = float(QUALITY);
    // Using a "spiral" to propagate points.
    for (int i=0; i<QUALITY; ++i) {
        float fi = float(i);
        float a = fi * GOLDEN_ANGLE;
        float r = sqrt(fi / q) * radius;
        vec2 p = c + r * vec2(cos(a), sin(a));
        sum += getColor(tpipe, p*tsize);
    }
    return sum / q;
}

void main()
{
    vec4 texColor = blur(inputTex,fsTextureNormalized,fsTextureSize,fsMix*size);
    vec4 colorA=mix(vec4(0,0,0,0),texColor,fsABSelect);
    vec4 colorB=mix(texColor,vec4(0,0,0,0),fsABSelect);
    mixColor(outColor, colorB, colorA, transitionProgressLinear);

    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
