//
// Fragment shader for Ripple effect (from Center)
//
// Author: Shirley - converted to rvfx - jb
//
//


#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float blendValue;
uniform float uBlendValue=1.0;

in vec2 fsTexture;
in vec2 fsMaskTexture;
in vec2 fsNormalizedUV;
in vec2 fsTextureSize;
in vec3 fsPosition;
in float fsTime;

out vec4 outColor;


void main(void)
{
    float cLength = length(fsPosition.xy);

    vec2 uv=fsNormalizedUV+(fsPosition.xy/cLength)*cos(cLength*12.0-fsTime*4.0)*0.03;
    uv*=fsTextureSize;

    vec4 texel=texture(inputTex,fsTexture);
    outColor=texture(inputTex,uv);
    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    mixColor(outColor, texel, outColor, blendValue);
}
