// Convert (and horizontal downsample) RGB to YUV2 using SD gamma corrected values (from Decklink SDK)
#version 330

uniform sampler2DRect inputTex;

const vec4 std601X = vec4(  0.257 ,  0.504,  0.098, 0.0  );
const vec4 std601Y = vec4( -0.148 , -0.291,  0.439, 0.0  );
const vec4 std601Z = vec4(  0.439 , -0.368, -0.071, 0.0  );

in vec2 fsTex0;
in vec2 fsTex1;

out vec4 outColor;

void main()
{
    vec4 texColor0;
    vec4 texColor1;
    vec4 yuv0;
    vec4 yuv1;

    texColor0 = texture(inputTex, fsTex0);

    texColor1 = texture(inputTex, fsTex1);

    yuv0 = vec4(dot(std601X, texColor0)+0.0625,
                dot(std601Y, texColor0)+0.5,
                dot(std601Z, texColor0)+0.5,
                1.0 );

    yuv1 = vec4(dot(std601X, texColor1)+0.0625,
                dot(std601Y, texColor1)+0.5,
                dot(std601Z, texColor1)+0.5,
                1.0 );


    outColor.a = yuv1.r;
    outColor.r = (yuv0.b+yuv1.b)*.5;
    outColor.b = (yuv0.g+yuv1.g)*.5;
    outColor.g = yuv0.r;
}


