
#include "metalShaderTypes.h"
#include "alpha.h"

typedef struct
{
    float4 burnColor;
} fxVars;

typedef struct
{
    float4 position [[position]];
    float2 tex1;
    float2 tex2;
    float2 texMask;
    float2 normPos;
    float mixValue;
} vertexOut2;

vertex vertexOut2 vertexFunc(uint vertexID [[ vertex_id ]],
                             const device txShaderVers* in[[ buffer(0) ]],
                             constant txShaderUniforms& u[[ buffer(3) ]],
                             constant fxVars& vars[[ buffer(2)]])
{
    vertexOut2 out;

    out.position=in[vertexID].pos*u.worldViewProj;

    out.tex1=in[vertexID].tex1;
    out.tex2=in[vertexID].tex2;
    out.texMask=in[vertexID].texMask;

    if(u.transitionState!=2)
    {
        if(u.transitionProgressLinear<=.5)
        {
            out.mixValue=0.;
        }
        else
        {
            out.mixValue=(u.transitionProgressLinear-.5f)*2.;
        }
    }
    else
    {
        if(u.transitionProgressLinear<=.5)
        {
            out.mixValue=(.5-u.transitionProgressLinear)*2.;
        }
        else
        {
            out.mixValue=0.;
        }
    }

    return out;
}

fragment float4 fragmentFunc(vertexOut2 input [[stage_in]]
                             ,texture2d<half> inputTex0 [[ texture(0) ]]
                             ,texture2d<half> inputTex1 [[ texture(1) ]]
                             ,texture2d<half> inputTexMask [[ texture(2) ]]
                             ,constant txShaderUniforms& u[[ buffer(2) ]]
                             ,constant subFXVars& subVars[[buffer(3)]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    float4 outColor = getColor(inputTex0, input.tex1);
    float alpha = input.mixValue * u.baseAlpha;

#ifdef USE_MASK
    alpha *= float(inputTexMask.sample(linearSampler, input.texMask).a);
#endif

    multiplyOpacity(outColor, alpha);
    return outColor;
}
