#include "dxShaderIncludes.h"


cbuffer uniforms : register( b0 )
{
    float alpha;
    float curLevel;
    float peakLevel;
    float pad[1];
};

// data structure : before vertex shader (mesh info)
struct vertexInfo
{
    float3 position : POSITION;
    float2 uv: TEXCOORD0;
};

// data structure : vertex shader to pixel shader
// also called interpolants because values interpolates through the triangle
// from one vertex to another
struct v2p
{
    float4 position : SV_POSITION;
    float2 uv : TEXCOORD0;
};


v2p vertexShader(vertexInfo input)
{
    v2p output;
    output.position = float4(input.position,1.0)*float4(1,-1,1,1);
    output.uv=input.uv;
    return output;
}

float4 pixelShader(v2p input) : SV_TARGET
{
    float4 outColor=inputTex0.Sample(linearSampler,input.uv);

    if((1.0-input.uv.y)>curLevel)
    {
        float diff=abs((1.0-input.uv.y)-peakLevel);
        if(diff>.005)
        {
            outColor.a=alpha;
        }
    }
    return outColor;
}
