#include "dxEffectIncludes.h"
#include "alpha.h"

fxVertexOut vertexShader(fxShaderVerts input)
{
    fxVertexOut output;
    output.position =float4(input.position,1);
    output.tex1 = input.tex1;
    output.texMask = input.texMask;
    return output;
}


float4 pixelShader(fxVertexOut input) : SV_TARGET
{
    float4 texel = getColor(inputTex,fsTexture);
#ifdef PRE_MULT
    divideAlpha(texel);
#endif
    float gray = dot(texel.rgb, float3(0.299, 0.587, 0.114));

    // convert grayscale to sepia
    float4 outColor = float4(gray * float3(1.2, 1.0, 0.8), texel.a);

    float blendValue=u.blendValue;

#ifdef USE_MASK
    blendValue*=getColor(inputTexMask,input.texMask).a;
#endif
    outColor.rgb=mix(texel.rgb,outColor.rgb,blendValue);
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
    return outColor;
}
