#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

uniform float uLocalTime;
uniform float speed;

out vec2 fsTexture;
out vec2 fsMaskTexture;
out vec2 fsNormalizedUV;
out vec2 fsTextureSize;
out vec3 fsPosition;

out float cosTime1;
out float cosTime2;
out float cosTime3;
out float fsTime;


void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);

    fsTexture=vsTexture;

    ivec2 texSize=textureSize(inputTex);
    fsTextureSize=vec2(texSize);
    fsPosition=vsPosition*vec3(1.0,fsTextureSize.y/fsTextureSize.x,1.0);
    fsNormalizedUV=vsTexture/fsTextureSize;
    fsMaskTexture = vsTextureMask;
    fsTime=uLocalTime*speed;
}

