#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsTextureSize;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in float fsABSelect;
in float fsMix;

out vec4 outColor;


void main()
{
    float x1 = transitionProgressLinear;
    vec2 p1 = fsTextureNormalized;

    x1=smoothstep(.20,.80,(x1*2.0+p1.x-1.0));

    vec2 tc1=(p1-.5)*(1.-x1)+.5;

    tc1=(p1-.5)*x1+.5;

    vec2 texA=mix(tc1,p1,transitionProgressLinear);
    vec2 texB=mix(p1,tc1,transitionProgressLinear);
    vec2 useTex=mix(texB,texA,fsABSelect);

    outColor = getColor(inputTex, useTex * fsTextureSize);
    float alpha = fsMix * baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
