#version 330

#include "transitionHelperGL.h"
#include "alpha.h"
#include "fadeHelper.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgress = 1.0;
uniform float baseAlpha = 1.0;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsMaskTexture;

out vec4 outColor;

void main()
{
    vec4 texColorA = getColor(inputTex, fsTexture);
    vec4 texColorB = getColor(inputTex1, fsTexture2);
    fadeDarkAB(outColor, texColorA, texColorB, transitionProgress);
    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
