#include "inputShaderHelper.h"
#include "alpha.h"


fragment float4 fragmentFunc(inputVertexType in [[stage_in]]
                                 ,texture2d<half> inputTex0 [[ texture(0) ]]
                                 ,texture2d<half> inputTex1 [[ texture(1) ]]
                                 ,texture2d<half> inputTex2 [[ texture(2) ]]
                                 ,texture2d<half> inputTex3 [[ texture(3) ]]
                                 ,texture2d<half> maskTex [[ texture(4) ]]
                                 ,constant planarUniforms& uniforms[[ buffer(0) ]]
)
{
    vec4 yuvIn;
    yuvIn.a=0.0;
    yuvIn.g = textureFetchNearest(inputTex0, in.texCoordY).r;
    yuvIn.br = textureFetchNearest(inputTex1, in.texCoordUV).rg;
    
#ifdef HAS_ALPHA
    yuvIn.a = textureFetchNearest(inputTex2, in.texCoordY).r;
#endif

#ifdef IS_10BIT
    yuvIn*=float4(64.0, 64.0, 64.0, 64.0);;
#endif
    
#ifdef IS_12BIT
    yuvIn*=float4(16.0, 16.0, 16.0, 16.0);
#endif
    
    yuvIn+=stdbias;

#ifndef HAS_ALPHA
    yuvIn.a=1.0;
#endif
    
    
    float4 outColor=vec4(dot(yuv2R, yuvIn),
                  dot(yuv2G, yuvIn),
                  dot(yuv2B, yuvIn),
                  yuvIn.a);

#ifdef USE_COLOR_PROFILE
#ifndef BT709
    float4 linear=toLinear(outColor);

    float4 srgbLinear=float4(dot(profileToRGB_R, linear),
                    dot(profileToRGB_G, linear),
                    dot(profileToRGB_B, linear),
                    outColor.a);
#else
    float4 srgbLinear=linearizeBT709(outColor);
#endif
    outColor=toGamma(srgbLinear);

#endif

    processAlpha(outColor);

#ifdef USE_MASK
    multiplyOpacity(outColor, textureFetchNearest(maskTex, in.maskCoord).a);
#endif

#ifdef USE_END_COLOR
    mixColor(outColor, uniforms.endColor, outColor, uniforms.endOpacity);
#endif

    return outColor;
}
