//
// Fragment shader for vignette photo effect
//
// Author: Jeff Brown
//
//

#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float uBlendValue=1.0;

in float fsOuterRadius;
in float fsInnerRadius;
in vec2 fsTexture;
in vec2 fsMaskTexture;
in vec3 fsPosition;
out vec4 outColor;

void main()
{
    vec4 texel = texture(inputTex, fsTexture);
    float dist = distance(fsPosition, vec3(0.0, 0.0, 0.0));
    float blend = 1.0 - (fsOuterRadius - dist) / (fsOuterRadius - fsInnerRadius);
    blend = clamp(blend, 0.0, 1.0);
    blend *= uBlendValue;
#ifdef USE_MASK
    blend *= texture(maskTex, fsMaskTexture).a;
#endif
    vec4 vignetteColor = vec4(0.0, 0.0, 0.0, 1.0);
    mixColor(outColor, texel, vignetteColor, blend);
}
