#include "metalShaderTypes.h"
#include "alpha.h"

vertex pixCopyVertexOut vertexFunc(uint vertexID [[ vertex_id ]],
                                   const device pixCopyVertexFormat* in [[ buffer(0) ]])
{
    pixCopyVertexOut out;
    out.position = in[vertexID].pos;
    out.texCoord = in[vertexID].tc;
    return out;
}

fragment float4 fragmentFunc(pixCopyVertexOut input [[stage_in]],
                             texture2d<half> evenTex [[ texture(0) ]],
                             texture2d<half> oddTex [[ texture(1) ]])
{
    float isOddLine = floor(fract(input.texCoord.y * 0.5) * 2.0);

    float2 texSize0 = float2(evenTex.get_width(), evenTex.get_height());
    float2 texSize1 = float2(oddTex.get_width(), oddTex.get_height());

    float4 texColor0 = float4(evenTex.sample(linearSampler, input.texCoord/texSize0));
    float4 texColor1 = float4(oddTex.sample(linearSampler, input.texCoord/texSize1));

    float4 outColor = mix(texColor1, texColor0, isOddLine);
    processAlpha(outColor);

    return outColor;
}
