#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect maskTex;
out vec2 fsMaskTexture;




uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;
uniform sampler2DRect inputTex1;
uniform sampler2DRect inputTex;

out vec2 fsTexture;
out vec2 fsTexture2;
out vec2 fsVertex;
out vec2 fsTextureNormalized;

void main()
{
    gl_Position=vec4(vsPosition,1.0)*worldViewProj;

    fsTexture = vsTexture;
    fsVertex=vsPosition.xy;

    ivec2 texSize=textureSize(inputTex);
    fsTextureNormalized=vsTexture;
    fsTexture = vsTexture*vec2(texSize);

    texSize=textureSize(inputTex1);
    fsTexture2= vsTexture2*vec2(texSize);

    fsMaskTexture=vsTextureMask*vec2(textureSize(maskTex));
}
