#version 330

#include "alpha.h"
#include "inputColorHelper.h"

uniform  sampler2DRect inputTex0;
uniform  sampler2DRect inputTex1;
uniform sampler2DRect inputTexMask;
uniform vec4 endColor;
uniform float endOpacity;

const vec4 std709R = vec4( 1.793,1.164383, 0.000000,0.0  );
const vec4 std709G = vec4(-0.534,1.164383,-0.213,0.0  );
const vec4 std709B = vec4( 0.000000,1.164383, 2.115,0.0  );

#ifdef FULL_RANGE
const vec4 stdbias = vec4(-0.5  , 0.0,  -0.5   ,0.0  );
#else
const vec4 stdbias = vec4(-0.5  , -0.0625,  -0.5   ,0.0  );
#endif


in vec2 fsTexture;
in vec2 fsSampleTexture;
in vec2 fsTextureMask;
out vec4 outColor;

void main()
{
    //outColor=texture(inputTex, fsSampleTexture);
    
    vec4 y0;
    vec4 y1;
    
    float isOddUV;
    
    isOddUV = floor(fract(fsTexture.x * 0.5) * 2.0);

    float alpha = 1.0;
#ifdef YUYV
    y0 = texture(inputTex0, fsSampleTexture).abgr;
#endif
    
#ifdef UYVY
    y0 = texture(inputTex0, fsSampleTexture);
#endif

#ifdef YUVA
    y0 = texture(inputTex0, fsSampleTexture);
    alpha = texture(inputTex1, fsSampleTexture).r;
#endif

    

    y1=y0;
    y1.g=y0.a;
    y0=mix(y0,y1,isOddUV);
    
    y0+=stdbias;
    
    outColor=vec4(dot(std709R, y0),
                  dot(std709G, y0),
                  dot(std709B, y0),
                  alpha);

    outColor=processColorProfile(outColor);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(inputTexMask, fsTextureMask).a);
#endif

#ifdef USE_END_COLOR
    mixColor(outColor, endColor, outColor, endOpacity);
#endif

}
