
function createCounters() {
	for (var aClock in counterArray) {
		//console.log("clear: "+counterArray[aClock]);
		counterArray[aClock].stop();
	};
	counterArray.length = 0;
	
	// get game clock
	var clockDuration = document.getElementById("gameClock").innerHTML;
	var clock = new Counter("gameClock", clockDuration);
	counterArray.push(clock);
	
	updateCounters();
}

function setServe(me) {
	var serveButton1 = document.getElementById("homePossession");
	var serveButton2 = document.getElementById("visitorPossession");
	var tag = (me==serveButton1?0:1)
	var paramString = (tag==0?"action=homePossession":"action=visitorPossession");
	$.ajax({
		   type: "POST",
		   url: "/html/scoreBoard",
		   data: paramString,
		   cache: false,
		   success: function(bonuses) {
		   if (tag == 1) {
					$(serveButton1).removeClass("active")
					$(serveButton2).addClass("active")
		   } else {
					$(serveButton1).addClass("active")
					$(serveButton2).removeClass("active")
		   }
		}
	});
}

function clearScores() {
	var index = document.querySelector('input[name=currentSet]:checked').value;
	var paramString = "action=clearScores";
	var homeScore = document.getElementById("homeValueBox");
	var visitorScore = document.getElementById("visitorValueBox");
	$.ajax({
		   type: "POST",
		   url: "/html/scoreBoard",
		   data: paramString,
		   cache: false,
		   success: function(html) {
		      homeScore.innerHTML = "0";
			  visitorScore.innerHTML = "0";
               location.reload();
		   }
	});
	
}

function updateSetScores() {
	var paramString = "action=updateSetScores";
	var setScoresContent = document.getElementById("setScoresContent");
	$.ajax({
		   type: "POST",
		   url: "/html/scoreBoard",
		   data: paramString,
		   cache: false,
		   success: function(html) {
				setScoresContent.innerHTML = html;
				getSetScores()
		   }
	});
}

function setCurrentSet() {
	var index = document.querySelector('input[name=currentSet]:checked').value;
	var paramString = "action=setCurrentSet+tag="+index;
	$.ajax({
		   type: "POST",
		   url: "/html/scoreBoard",
		   data: paramString,
		   cache: false,
		   success: function(html) {
               location.reload();
		}
	});
}

function getSetScores(){
	var paramString = "action=getSetScores";
	var homeGamesWon = document.getElementById("homeGamesWonValueBox");
	var visitorGamesWon = document.getElementById("visitorGamesWonValueBox");

	$.ajax({
		   type: "POST",
		   url: "/html/scoreBoard",
		   data: paramString,
		   cache: false,
		   success: function(string) {
			   var array = string.split(',');
			   if (array.length == 2){
				   homeGamesWon.innerHTML = array[0];
				   visitorGamesWon.innerHTML = array[1];
			   }
		   }
	});
}
