
function createCounters() {
    for (var aClock in counterArray) {
        //console.log("clear: "+counterArray[aClock]);
        counterArray[aClock].stop();
    };
    counterArray.length = 0;
    
    // get game clock
    var clockDuration = document.getElementById("gameClock").innerHTML;
    var clock = new Counter("gameClock", clockDuration);
    counterArray.push(clock);
    
    for (var i=0;i<2;i++){
        var counter = 0;
        var working = true;
        while (working) {
            var elementIDString = "penalty"+i+"TimeValue"+counter;
            var tableRowIdString = "penalty"+i+"Row"+counter;
            var theElement = document.getElementById(elementIDString);
            if(theElement != null){
                var penaltyClock = new Counter(elementIDString, theElement.innerHTML, tableRowIdString);
                counterArray.push(penaltyClock);
            }else{
                working = false;
            }
            counter++;
        };
    }
    updateCounters();
}

function getPenalties(team) {
    var paramString = "action=getPenalties+tag="+team;
    var tableContents = document.getElementById("penaltyTableContents"+team);
    
    // post the string, asking the server for the preview string using these token fields
    $.ajax({
	   type: "POST",
	   url: "/html/scoreBoard",
	   data: paramString,
	   cache: false,
	   success: function(html) {
			tableContents.innerHTML = html;
		}
	});
};

function removePenalty(team, index) {
    var paramString = "action=removePenalty+tag="+team+"_"+index;
    var tableContents = document.getElementById("penaltyTableContents"+team);
    
    // post the string, asking the server for the preview string using these token fields
    $.ajax({
           type: "POST",
           url: "/html/scoreBoard",
           data: paramString,
           cache: false,
           success: function(html) {
                tableContents.innerHTML = html;
                createCounters();
           }
    });
}

function removePenaltyRow(team,row) {
    var trID = "#penalty"+team+"Row"+row;
    $(trID).remove();
}

