

function createCounter(object) {
	var identifier = object.attr("associatedValueBox");
	var durationField = document.getElementById(identifier);
	var clock = null;
	for (var index in counterArray) {
		var c = counterArray[index];
		if (c.id == identifier) {
			clock = c;
			clock.stop();
			break;
		}
	};
	
	if (clock != null) {
		counterArray.pop(clock);
	}
	
	var clock = new Counter(identifier, durationField.innerHTML);
	counterArray.push(clock);
	updateCounter(object)
}


function updateCounter(object) {
	var tag = object.attr("tag");
	var associate = object.attr("associatedValueBox");
	var button = object[0];
	//console.log("me: "+object[ 0 ]+", button: "+button);
	$.ajax({
		   type: "POST",
		   url: "/html/scoreBoard",
		   data: "action=clockStatus+tag="+tag,
		   cache: false,
		   success: function(html) {
			   //console.log("updateCounters");
			   // get game clock button
			   var iteratedClock;
			   if(parseInt(html) == 1){
				   button.innerHTML = "Stop";
				   for (var index in counterArray) {
					   var clock = counterArray[index];
					   if (clock.id == associate) {
						   clock.start();
						   break;
					   };
				   };
			   }else{
				   button.innerHTML = "Start";
				   for (var index in counterArray) {
					   var clock = counterArray[index];
					   if (clock.id == associate) {
						   clock.stop();
						   break;
		   				};
				   };
			   }
		   }
		});
}


function edit(me, id) {
	me.style.display = "none";
	var text = document.getElementById(id);
	text.value = "";
	text.style.display = "inline-block";
	text.select();
}


function executeKeyDownForValueEdit(event, me, id, arguements) {
	if(event.code=='Enter' && me.value.length > 0){
		var button = document.getElementById(id);
		button.firstChild.nodeValue = me.value;
		setValue(me, id, arguements);
	}else if(event.code=='Escape'){
		endEditTime(me, id);
	}
}


function setValue(me, id, arguements) {
	var tag = arguements+","+me.value;
	
	var previewField = document.getElementById(id);
	
	$.ajax({
		   type: "POST",
		   url: "/html/scoreBoard",
		   data: "action=setValue+tag="+tag,
		   cache: false,
		   success: function(html) {
			   console.log("updateCounters");
			   previewField.innerHTML = html;
		   }
		});
	
	endEdit(me, id);
}


function endEdit(me, id) {
	me.style.display = "none";
	var button = document.getElementById(id);
	button.style.display = "inline-block";
}


function executeKeyDownForTimeEdit(event, me, id, arguements) {
	if(event.code=='Enter' && me.value.length > 0){
		var button = document.getElementById(id);
		button.firstChild.nodeValue = me.value;
		setDuration(me, id, arguements);
	}else if(event.code=='Escape'){
		endEdit(me, id);
	}
}


function setDuration(me, id, arguements) {
	var tag = arguements+","+me.value;
	
	var previewField = document.getElementById(id);
	
	$.ajax({
		   type: "POST",
		   url: "/html/scoreBoard",
		   data: "action=clockDuration+tag="+tag,
		   cache: false,
		   success: function(html) {
			   //console.log("updateCounters");
			   previewField.innerHTML = html;
		   }
		});
	
	endEdit(me, id);
}


