
function createCounters() {
    //console.log("createCounters");
    for (var aClock in counterArray) {
        counterArray[aClock].stop();
    };
    counterArray.length = 0;
    
    // get game clock
    var clockDuration = document.getElementById("gameClock").innerHTML;
    var clock = new Counter("gameClock", clockDuration);
    
    //console.log("gameClock: "+clock);
    counterArray.push(clock);
    
    updateCounters();
}

function newBatter() {
	var paramString = "action=newBatter";
	var balls = document.getElementById("ballsValueBox");
	var strikes = document.getElementById("strikesValueBox");
	
	$.ajax({
	   type: "POST",
	   url: "/html/scoreBoard",
	   data: paramString,
	   cache: false,
	   success: function() {
		   balls.innerHTML = "0";
		   strikes.innerHTML = "0";
	   }
	});
}

function setAtBat(team) {
	var paramString = "action="+(team==0?"setHomeAtBat":"setVisitorAtBat");	
	$.ajax({
	   type: "POST",
	   url: "/html/scoreBoard",
	   data: paramString,
	   cache: false,
	   success: function(stringArray) {
		   updateScoringFromStringArray(stringArray);
		   getInningTable();
	   }
	});
}

function getScoring() {
	var paramString = "action=getScoring";
	
	$.ajax({
	   type: "POST",
	   url: "/html/scoreBoard",
	   data: paramString,
	   cache: false,
	   success: function(stringArray) {
			updateScoringFromStringArray(stringArray);
	   }
	});
};

function getAtBat() {
	var paramString = "action=getAtBat";
	var homeAtBat = document.getElementById("homeAtBatButton");
	var visitorAtBat = document.getElementById("visitorAtBatButton");

	$.ajax({
		type: "POST",
		url: "/html/scoreBoard",
		data: paramString,
		cache: false,
		success: function(team) {
		   if (team == 0) {
			   $(homeAtBat).addClass("active")
			   $(visitorAtBat).removeClass("active")
		   } else {
			   $(homeAtBat).removeClass("active")
			   $(visitorAtBat).addClass("active")
		   }
		}
	});
}

function updateScoringFromStringArray(string) {
	var ball = document.getElementById("ballsValueBox");
	var strk = document.getElementById("strikesValueBox");
	var outs = document.getElementById("outsValueBox");
	var hits = document.getElementById("hitsValueBox");
	var runs = document.getElementById("runsValueBox");
	var errs = document.getElementById("errorValueBox");
	var array = string.split(',');
	if (array.length == 6){
		ball.innerHTML = array[0];
		strk.innerHTML = array[1];
		outs.innerHTML = array[2];
		hits.innerHTML = array[3];
		runs.innerHTML = array[4];
		errs.innerHTML = array[5];
	}
}

function getInningTable() {
	var paramString = "action=getInningTable";
	var tableContents = document.getElementById("inningContents");
	
	$.ajax({
	   type: "POST",
	   url: "/html/scoreBoard",
	   data: paramString,
	   cache: false,
	   success: function(html) {
		   tableContents.innerHTML = html;
	   }
	});
};

function updateInningValue(me){
	var event = window.event;
	var charCode = event.which || event.keyCode;
	
	if ( charCode == '13' ) {
		// Enter pressed
		//console.log(me.id+" "+me.value);
		var paramString = "action=updateInningTableValue";
		paramString += "+tag="+me.id+","+me.value;
		
		$.ajax({
		   type: "POST",
		   url: "/html/scoreBoard",
		   data: paramString,
		   cache: false,
		   success: function(html) {
			   getScoring();
			   getInningTable();
		   }
		});
	}
}
