#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;


uniform mat4 worldViewProj;
uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;

out vec2 fsTexture;
out vec2 fsTexture2;
out vec2 fsTextureNormalized;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    
    vec2 fsVertex=vsPosition.xy;
    
    ivec2 texSize=textureSize(inputTex);
    fsTexture = vsTexture;
    fsTextureNormalized=fsTexture/vec2(texSize);
    
    texSize=textureSize(inputTex1);
    fsTexture2=vec2(texSize)*fsTextureNormalized;
    fsTextureNormalized=1.0-fsTextureNormalized;
}
