#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform int transitionState;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureNormalized;
out vec4 outColor;

void main()
{
    vec4 colorA = texture(inputTex, fsTexture)*baseAlpha;
    vec4 colorB = texture(inputTex1, fsTexture2)*baseAlpha;

    float tp=transitionProgress*1.1;
    
    float diffIn=tp-(fsTextureNormalized.x+fsTextureNormalized.y)*.5;
    diffIn=clamp(diffIn*10.0,0.0,1.0);
    
    float diffOut=(fsTextureNormalized.x+fsTextureNormalized.y)*.5-(tp-.1);
    diffOut=clamp(diffOut*10.0,0.0,1.0);

    outColor=colorA*diffIn+colorB*diffOut;
}


