#version 330

uniform sampler2DRect inputTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

uniform mat4 worldViewProj;
uniform int transitionState;

out vec2 fsTexture;
out vec2 fsTextureNormalized;
out float fsMix;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    
    fsTexture = vsTexture;
    ivec2 texSize=textureSize(inputTex);
    fsTextureNormalized=fsTexture/vec2(texSize);
    if(transitionState==0)
        fsMix=0.0;
    else
        fsMix=1.0;
    fsTextureNormalized.y=1.0-fsTextureNormalized.y;
}
