#version 330

uniform sampler2DRect inputTex;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform int transitionState;

in vec2 fsTexture;
in vec2 fsTextureNormalized;
in float fsMix;
out vec4 outColor;

void main()
{
    outColor = texture(inputTex, fsTexture)*baseAlpha;
    float tp=(1.0-transitionProgress)*1.1;

    float diffIn=fsTextureNormalized.y-(tp-.1);
    diffIn=clamp(diffIn*10.0,0.0,1.0);

    float diffOut=tp-fsTextureNormalized.y;
    diffOut=clamp(diffOut*10.0,0.0,1.0);

    outColor*=mix(diffIn,diffOut,fsMix);
}


