#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;


uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;

out vec2 fsTexture;

void main()
{
    vec4 transOffset=vec4(0.,-1.,4.0,.0);


    float zTimer=0.;
    float xTimer=0.;
    float xScale=1.;
    float rTimer=0.;
    if(transitionState==0)
    {
        rTimer=3.1415926535897932384626433832795*-.2+transitionProgress*3.1415926535897932384626433832795*.2;
        xTimer=3.1415926535897932384626433832795-transitionProgress*3.1415926535897932384626433832795;
        zTimer=transitionProgress*3.1415926535897932384626433832795;
        xScale=-1.;
    }
    else if(transitionState==2)
    {
        rTimer=transitionProgress*3.1415926535897932384626433832795*.2;
        xTimer=transitionProgress*3.1415926535897932384626433832795;
        zTimer=3.1415926535897932384626433832795-transitionProgress*3.1415926535897932384626433832795;
        xScale=1.;
    }

    mat4 rotation = mat4(
                          cos(rTimer),  0.0,-sin(rTimer), 0.0,
                                 0.0,  1.0,        0.0, 0.0,
                         sin(rTimer),  0.0, cos(rTimer), 0.0,
                                 0.0,  0.0,        0.0, 1.0);
    mat4 projection = mat4(
                           2.4140,0.0000,0.0000,0.0000,
                           0.0000,2.4140,0.0000,0.0000,
                           0.0000,0.0000,-1.020,-.4870,
                           0.0000,0.0000,-1.000,0.0000);

    float zvalue=cos(zTimer)*-1.5-1.5;
    float xvalue=sin(xTimer)*xScale;
    mat4 translation=mat4(
                            1.0, 0.0, 0.0, 0.00,
                            0.0, 1.0, 0.0, 0.00,
                            0.0, 0.0, 1.0,-2.42,
                            0.0, 0.0, 0.0, 1.00);
    
    vec4 tmpPos=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;

    translation[0][3]+=xvalue;
    translation[2][3]+=zvalue;

    vec4 worldPos=tmpPos*rotation;
    worldPos*=translation;
	gl_Position = worldPos*projection;
    
	fsTexture = vsTexture;
}
