#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;


uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;
uniform sampler2DRect inputTex;

out vec2 fsTexture;
out vec2 fsTexNormalized;
out vec2 fsTexSize;

void main()
{
	fsTexture = vsTexture;
    vec2 fsVertex=vsPosition.xy;

    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;

    ivec2 texSize=textureSize(inputTex);
    fsTexSize=vec2(texSize);
    fsTexNormalized=(fsVertex+vec2(1.0,1.0))*vec2(.5,.5);
}
