#version 330

uniform sampler2DRect inputTex;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;

in vec2 fsTexture;
in vec2 fsTexNormalized;
in vec2 fsTexSize;
out vec4 outColor;

void main()
{

    float rad = 0.708 * transitionProgress; // radius from center of the uv texture square
    float swell = 0.2; // swell region magnitude
    vec2 CPoint = vec2(0.5, 0.5); // center point
    float dist = length((fsTexNormalized - CPoint)/vec2(0.70,1));
    vec2 uvOrig = fsTexture/fsTexSize;
    vec2 uvNew = uvOrig;
    float alpha = 0; // blend factor between the 2 textures
    if (dist < rad) // show the new texture - this expands from center outwards
    {
        alpha = 1; //when inside, show the new texture colour
    }
    if (dist > rad && dist < rad + swell)
    {
        float lambda = smoothstep(rad, rad+swell, dist); // factor in [0,1]
        alpha = 1 - lambda; // modified blend factor
        vec2 vec = (uvOrig - CPoint) ;
        vec2 dir = ((vec)/(length(vec/vec2(0.70,1)))) ;
        uvOrig = CPoint + ((1-lambda) * rad + lambda * (rad+swell)) * dir;
    }
    if (dist >= rad + swell)
        alpha = 0; // show the old texture only
    if(transitionState!=0)
    {
        uvOrig*=fsTexSize;
        outColor=texture(inputTex,uvOrig)*(1.0-alpha)*baseAlpha;
//        outColor.a*=(1.0-alpha);
    }
    else
    {
        uvNew*=fsTexSize;
        outColor=texture(inputTex,uvNew)*alpha*baseAlpha;
//        outColor.a*=alpha;
    }
}


