#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;


uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;

out vec2 fsTexture;
out float fsMix;

void main()
{
    vec4 deltaTrans=vec4(0.,2.,0.,.0);
    vec4 transOffset=vec4(0.,2.,0.0,.0);
    
    mat4 translation=mat4(
                            1.0, 0.0, 0.0, 0.00,
                            0.0, 1.0, 0.0, 0.00,
                            0.0, 0.0, 1.0, 0.00,
                            0.0, 0.0, 0.0, 1.00);
    
    
    vec4 tmpPos=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    if(transitionState==0)
    {
        transOffset-=deltaTrans*transitionProgress;
        
        translation[0][3]+=transOffset.x;
        translation[1][3]+=transOffset.y;
        translation[2][3]+=transOffset.z;
        fsMix=1.;
    }
    else
    {
        fsMix=(1.0-transitionProgress);
    }
    gl_Position = tmpPos*translation;
    
	fsTexture = vsTexture;
}
