#version 330

uniform sampler2DRect inputTex;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;

vec2 FirstCenter=vec2(.15,.15);
vec2 SecondCenter=vec2(.5,.15);
vec2 FirstAspectRatio=vec2(.15,.15);
vec2 SecondAspectRatio=vec2(.10,.15);

in vec2 fsTexture;
in vec2 fsVertex;
in vec2 fsTexNormalized;
in float texWidth;
out vec4 outColor;

void main()
{
    outColor=vec4(0,0,0,0);
    
	vec2 center = FirstCenter;
	
	float i = (floor(fsTexNormalized.y / 0.15) - 1) * 0.15;
	center.y = center.y + i;
	vec2 uvMinusCenter = fsTexNormalized - center;
	float uvMinusCenter1x = uvMinusCenter.x - (SecondCenter.x - FirstCenter.x);
	float len = length(uvMinusCenter / FirstAspectRatio);
	len = min(len, length(vec2(uvMinusCenter1x,uvMinusCenter.y)  / SecondAspectRatio));
	
	uvMinusCenter.y = uvMinusCenter.y - 0.15;
	len = min(len, length(uvMinusCenter / FirstAspectRatio));
	len = min(len, length(vec2(uvMinusCenter1x,uvMinusCenter.y) / SecondAspectRatio));
	
	uvMinusCenter.y = uvMinusCenter.y - 0.15;
	len = min(len, length(vec2(uvMinusCenter1x,uvMinusCenter.y) / SecondAspectRatio));
    
	if(len < transitionProgress)
	{
        if(transitionState==0.0)
            outColor=texture(inputTex,fsTexture);
	}
	else
	{
        if(transitionState==2.0)
            outColor=texture(inputTex,fsTexture);
	}
}

